<?php
/**
 * German language strings.
 *
 * This file is part of ADOdb, a Database Abstraction Layer library for PHP.
 *
 * @see https://adodb.org Project's web site and documentation
 * @see https://github.com/ADOdb/ADOdb Source code and issue tracker
 *
 * The ADOdb Library is dual-licensed, released under both the BSD 3-Clause
 * and the GNU Lesser General Public Licence (LGPL) v2.1 or, at your option,
 * any later version. This means you can use it in proprietary products.
 * See the LICENSE.md file distributed with this source code for details.
 *
 * @license BSD-3-Clause
 * @license LGPL-2.1-or-later
 * @copyright 2000-2013 John Lim
 * @copyright 2014 Damien Regad, Mark Newnham and the ADOdb community
 * @author Heinz Hombergs <opn@hhombergs.de>
 */
$ADODB_LANG_ARRAY = [
    'LANG' => 'de',
    DB_ERROR => 'unbekannter Fehler',
    DB_ERROR_ALREADY_EXISTS => 'existiert bereits',
    DB_ERROR_CANNOT_CREATE => 'kann nicht erstellen',
    DB_ERROR_CANNOT_DELETE => 'kann nicht löschen',
    DB_ERROR_CANNOT_DROP => 'Tabelle oder Index konnte nicht gelöscht werden',
    DB_ERROR_CONSTRAINT => 'Randbedingung verletzt',
    DB_ERROR_DIVZERO => 'Division durch Null',
    DB_ERROR_INVALID => 'ungültig',
    DB_ERROR_INVALID_DATE => 'ungültiges Datum oder Zeit',
    DB_ERROR_INVALID_NUMBER => 'ungültige Zahl',
    DB_ERROR_MISMATCH => 'Unverträglichkeit',
    DB_ERROR_NODBSELECTED => 'Keine Datenbank ausgewählt',
    DB_ERROR_NOSUCHFIELD => 'Feld nicht vorhanden',
    DB_ERROR_NOSUCHTABLE => 'Tabelle nicht vorhanden',
    DB_ERROR_NOT_CAPABLE => 'Funktion nicht installiert',
    DB_ERROR_NOT_FOUND => 'nicht gefunden',
    DB_ERROR_NOT_LOCKED => 'nicht gesperrt',
    DB_ERROR_SYNTAX => 'Syntaxfehler',
    DB_ERROR_UNSUPPORTED => 'nicht unterstützt',
    DB_ERROR_VALUE_COUNT_ON_ROW => 'Anzahl der zurückgelieferten Felder entspricht nicht der Anzahl der Felder in der Abfrage',
    DB_ERROR_INVALID_DSN => 'ungültiger DSN',
    DB_ERROR_CONNECT_FAILED => 'Verbindung konnte nicht hergestellt werden',
    0 => 'kein Fehler', // DB_OK
    DB_ERROR_NEED_MORE_DATA => 'Nicht genügend Daten geliefert',
    DB_ERROR_EXTENSION_NOT_FOUND => 'Erweiterung nicht gefunden',
    DB_ERROR_NOSUCHDB => 'keine Datenbank',
    DB_ERROR_ACCESS_VIOLATION => 'ungenügende Rechte',
];
