<?php
/**
 * ListMessenger Pro - Classic Mailing List Management
 * For the most recent version, visit https://listmessenger.com.
 *
 * @copyright 2002-2022 Silentweb https://silentweb.ca
 * @author Matt Simpson <msimpson@listmessenger.com>
 * @license /licence.html ListMessenger Software Licence Agreement
 */
if (!defined('IN_SETUP')) {
    exit;
}

$LMDATABASE = [];
$LMDATABASE['new'] = <<<ENDDB
    CREATE TABLE `%TABLES_PREFIX%cdata` (`cdata_id` int(12) NOT NULL auto_increment, `user_id` int(12) NOT NULL default '0', `cfield_id` int(12) NOT NULL default '0', `value` longtext NOT NULL, PRIMARY KEY (`cdata_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%cfields` (`cfields_id` int(12) NOT NULL auto_increment, `field_type` varchar(16) NOT NULL default '', `field_options` longtext, `field_sname` varchar(16) default NULL, `field_lname` varchar(64) default NULL, `field_length` int(12) default '0', `field_req` int(1) NOT NULL default '0', `field_order` int(3) NOT NULL default '0', PRIMARY KEY (`cfields_id`), UNIQUE KEY `field_sname` (`field_sname`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%confirmation` (`confirm_id` int(12) NOT NULL auto_increment, `date` bigint(64) NOT NULL default '0', `action` varchar(16) NOT NULL default '', `remote_ip` varchar(32) NOT NULL default '', `referrer` text NOT NULL, `user_agent` text NOT NULL, `email_address` varchar(128) NOT NULL default '', `firstname` varchar(32) NOT NULL default '', `lastname` varchar(64) NOT NULL default '', `group_ids` text NOT NULL, `cdata` text NOT NULL, `hash` varchar(64) NOT NULL default '', `confirmed` int(1) NOT NULL default '0', PRIMARY KEY (`confirm_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%groups` (`groups_id` int(12) NOT NULL auto_increment, `group_name` varchar(64) NOT NULL default '', `group_parent` int(12) NOT NULL default '0', `group_private` enum('true','false') NOT NULL default 'false', PRIMARY KEY (`groups_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%messages` (`message_id` int(12) NOT NULL auto_increment, `message_date` bigint(64) NOT NULL default '0', `message_title` varchar(255) NOT NULL default '', `message_subject` varchar(255) NOT NULL default '(no subject)', `message_from` text NOT NULL, `message_reply` text NOT NULL, `message_priority` int(1) NOT NULL default '0', `text_message` longtext NOT NULL, `text_template` int(12) default NULL, `html_message` longtext NOT NULL, `html_template` int(12) default NULL, `attachments` text NOT NULL, PRIMARY KEY (`message_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%preferences` (`preference_id` int(12) NOT NULL auto_increment, `preference_value` text NOT NULL, PRIMARY KEY (`preference_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=53;
    CREATE TABLE `%TABLES_PREFIX%queue` (`queue_id` int(12) NOT NULL auto_increment, `message_id` int(12) NOT NULL default '0', `date` bigint(64) NOT NULL default '0', `touch` bigint(64) NOT NULL default '0', `target` text NOT NULL, `progress` int(12) NOT NULL default '0', `total` int(12) NOT NULL default '0', `status` varchar(25) NOT NULL default '', PRIMARY KEY (`queue_id`), KEY `date` (`date`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%sending` (`sending_id` int(12) NOT NULL auto_increment, `email_address` varchar(128) NOT NULL default '', `users_id` int(12) NOT NULL default '0', `queue_id` int(12) NOT NULL default '0', `sent` tinyint(1) NOT NULL default '0', PRIMARY KEY  (`sending_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%sessions` (`sesskey` VARCHAR( 64 ) NOT NULL DEFAULT '', `expiry` TIMESTAMP NOT NULL, `expireref` VARCHAR( 250 ) DEFAULT '', `created` TIMESTAMP NOT NULL, `modified` TIMESTAMP NOT NULL, `sessdata` LONGTEXT, PRIMARY KEY (`sesskey`), INDEX sess2_expiry(`expiry`), INDEX sess2_expireref(`expireref`)) ENGINE=%TABLES_ENGINE%;
    CREATE TABLE `%TABLES_PREFIX%templates` (`template_id` int(12) NOT NULL auto_increment, `template_name` varchar(64) NOT NULL default '', `template_type` varchar(4) NOT NULL default 'html', `template_description` text, `template_content` longtext NOT NULL, PRIMARY KEY (`template_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%users` (`users_id` int(12) NOT NULL auto_increment, `group_id` int(12) NOT NULL default '0', `signup_date` bigint(64) NOT NULL default '0', `firstname` varchar(32) default NULL, `lastname` varchar(64) default NULL, `email_address` varchar(128) NOT NULL default '', PRIMARY KEY (`users_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%user_updates` (`updates_id` int(12) NOT NULL auto_increment, `hash` varchar(32) NOT NULL default '', `date` bigint(64) NOT NULL default '0', `email_address` varchar(128) NOT NULL default '0', `completed` int(1) NOT NULL default '0', PRIMARY KEY (`updates_id`), UNIQUE KEY `hash` (`hash`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (1, '%preferences[1]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (2, '%preferences[2]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (3, '%preferences[3]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (4, '%preferences[4]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (5, '2.2.3');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (6, '%preferences[6]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (7, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (8, '%preferences[8]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (9, '25');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (10, 'archive.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (11, 'confirm.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (12, 'help.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (13, 'unsubscribe.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (14, '%preferences[14]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (15, '%preferences[15]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (16, '%preferences[14]%public/');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (17, '76');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (18, '75');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (19, '%preferences[19]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (20, '%preferences[20]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (21, '%preferences[21]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (22, '%preferences[22]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (23, 'M jS Y g:ia');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (24, '1');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (25, 'mail');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (26, '');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (27, 'false');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (28, '');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (29, '');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (30, 'tiny_mce');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (31, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (32, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (33, 'listmessenger.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (34, 'template.html');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (35, '%preferences[35]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (36, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (37, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (38, '');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (39, '');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (40, 'english');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (41, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (42, '60');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (43, '%preferences[43]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (44, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (45, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (46, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (47, '%preferences[15]%public/');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (48, '%preferences[14]%private/');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (49, 'ISO-8859-1');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (50, '7');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (51, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (52, '-5');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (53, '0');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (54, '0');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (55, '0');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (56, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (57, 'profile.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (58, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (59, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (60, '');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (61, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (62, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (63, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (64, 'forward.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (65, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (66, 'htmlentities');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (67, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (68, '');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (69, 'n');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (70, 'yes');
    ALTER TABLE `%TABLES_PREFIX%users` ADD INDEX (`group_id`);
    ALTER TABLE `%TABLES_PREFIX%users` ADD INDEX (`signup_date`);
    ALTER TABLE `%TABLES_PREFIX%users` ADD INDEX (`email_address`);
    ALTER TABLE `%TABLES_PREFIX%templates` ADD INDEX (`template_type`);
    ALTER TABLE `%TABLES_PREFIX%cdata` ADD INDEX (`user_id`);
    ALTER TABLE `%TABLES_PREFIX%cdata` ADD INDEX (`cfield_id`);
    ALTER TABLE `%TABLES_PREFIX%cfields` ADD INDEX (`field_sname`);
    ALTER TABLE `%TABLES_PREFIX%cfields` ADD INDEX (`field_lname`);
    ALTER TABLE `%TABLES_PREFIX%cfields` ADD INDEX (`field_type`);
    ALTER TABLE `%TABLES_PREFIX%cfields` ADD INDEX (`field_req`);
    ALTER TABLE `%TABLES_PREFIX%cfields` ADD INDEX (`field_order`);
    ENDDB;

$LMDATABASE['upgrade']['error'] = <<<ENDDB
    DROP TABLE IF EXISTS `%TABLES_PREFIX%cdata`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%cfields`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%confirmation`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%groups`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%messages`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%preferences`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%queue`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%sending`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%templates`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%users`;
    ENDDB;

$LMDATABASE['upgrade']['1.0.0']['new'] = <<<ENDDB
    CREATE TABLE `%TABLES_PREFIX%cdata` (`cdata_id` int(12) NOT NULL auto_increment, `user_id` int(12) NOT NULL default '0', `cfield_id` int(12) NOT NULL default '0', `value` longtext NOT NULL, PRIMARY KEY (`cdata_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%cfields` (`cfields_id` int(12) NOT NULL auto_increment, `field_type` varchar(16) NOT NULL default '', `field_options` longtext, `field_sname` varchar(16) default NULL, `field_lname` varchar(64) default NULL, `field_length` int(12) default '0', `field_req` int(1) NOT NULL default '0', `field_order` int(3) NOT NULL default '0', PRIMARY KEY (`cfields_id`), UNIQUE KEY `field_sname` (`field_sname`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%confirmation` (`confirm_id` int(12) NOT NULL auto_increment, `date` bigint(64) NOT NULL default '0', `action` varchar(16) NOT NULL default '', `remote_ip` varchar(32) NOT NULL default '', `referrer` text NOT NULL, `user_agent` text NOT NULL, `email_address` varchar(128) NOT NULL default '', `firstname` varchar(32) NOT NULL default '', `lastname` varchar(64) NOT NULL default '', `group_ids` text NOT NULL, `cdata` text NOT NULL, `hash` varchar(64) NOT NULL default '', `confirmed` int(1) NOT NULL default '0', PRIMARY KEY (`confirm_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%groups` (`groups_id` int(12) NOT NULL auto_increment, `group_name` varchar(64) NOT NULL default '', `group_parent` int(12) NOT NULL default '0', `group_private` enum('true','false') NOT NULL default 'false', PRIMARY KEY (`groups_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%messages` (`message_id` int(12) NOT NULL auto_increment, `message_date` bigint(64) NOT NULL default '0', `message_title` varchar(255) NOT NULL default '', `message_subject` varchar(255) NOT NULL default '(no subject)', `message_from` text NOT NULL, `message_reply` text NOT NULL, `message_priority` int(1) NOT NULL default '0', `text_message` longtext NOT NULL, `text_template` int(12) default NULL, `html_message` longtext NOT NULL, `html_template` int(12) default NULL, `attachments` text NOT NULL, PRIMARY KEY (`message_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%preferences` (`preference_id` int(12) NOT NULL auto_increment, `preference_value` text NOT NULL, PRIMARY KEY (`preference_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=53;
    CREATE TABLE `%TABLES_PREFIX%queue` (`queue_id` int(12) NOT NULL auto_increment, `message_id` int(12) NOT NULL default '0', `date` bigint(64) NOT NULL default '0', `touch` bigint(64) NOT NULL default '0', `target` text NOT NULL, `progress` int(12) NOT NULL default '0', `total` int(12) NOT NULL default '0', `status` varchar(25) NOT NULL default '', PRIMARY KEY (`queue_id`), KEY `date` (`date`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%sending` (`sending_id` int(12) NOT NULL auto_increment, `email_address` varchar(128) NOT NULL default '', `users_id` int(12) NOT NULL default '0', `queue_id` int(12) NOT NULL default '0', `sent` tinyint(1) NOT NULL default '0', PRIMARY KEY  (`sending_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%sessions` (`sesskey` VARCHAR( 64 ) NOT NULL DEFAULT '', `expiry` TIMESTAMP NOT NULL, `expireref` VARCHAR( 250 ) DEFAULT '', `created` TIMESTAMP NOT NULL, `modified` TIMESTAMP NOT NULL, `sessdata` LONGTEXT, PRIMARY KEY (`sesskey`), INDEX sess2_expiry(`expiry`), INDEX sess2_expireref(`expireref`)) ENGINE=%TABLES_ENGINE%;
    CREATE TABLE `%TABLES_PREFIX%templates` (`template_id` int(12) NOT NULL auto_increment, `template_name` varchar(64) NOT NULL default '', `template_type` varchar(4) NOT NULL default 'html', `template_description` text, `template_content` longtext NOT NULL, PRIMARY KEY (`template_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%users` (`users_id` int(12) NOT NULL auto_increment, `group_id` int(12) NOT NULL default '0', `signup_date` bigint(64) NOT NULL default '0', `firstname` varchar(32) default NULL, `lastname` varchar(64) default NULL, `email_address` varchar(128) NOT NULL default '', PRIMARY KEY (`users_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%user_updates` (`updates_id` int(12) NOT NULL auto_increment, `hash` varchar(32) NOT NULL default '', `date` bigint(64) NOT NULL default '0', `email_address` varchar(128) NOT NULL default '0', `completed` int(1) NOT NULL default '0', PRIMARY KEY (`updates_id`), UNIQUE KEY `hash` (`hash`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (1, '%preferences[1]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (2, '%preferences[2]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (3, '%preferences[3]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (4, '%preferences[4]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (5, '2.2.1');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (6, '%preferences[6]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (7, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (8, '%preferences[8]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (9, '%preferences[9]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (10, 'archive.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (11, 'confirm.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (12, 'help.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (13, 'unsubscribe.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (14, '%preferences[14]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (15, '%preferences[15]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (16, '%preferences[14]%public/');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (17, '%preferences[17]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (18, '%preferences[18]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (19, '%preferences[19]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (20, '%preferences[20]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (21, '%preferences[21]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (22, '%preferences[22]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (23, '%preferences[23]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (24, '%preferences[24]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (25, '%preferences[25]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (26, '%preferences[26]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (27, '%preferences[27]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (28, '%preferences[28]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (29, '%preferences[29]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (30, 'tiny_mce');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (31, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (32, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (33, '%preferences[33]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (34, '%preferences[34]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (35, '%preferences[35]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (36, '%preferences[36]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (37, '%preferences[37]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (38, '%preferences[38]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (39, '%preferences[39]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (40, '%preferences[40]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (41, '%preferences[41]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (42, '60');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (43, '%preferences[19]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (44, '%preferences[44]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (45, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (46, '%preferences[46]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (47, '%preferences[15]%public/');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (48, '%preferences[14]%private/');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (49, 'ISO-8859-1');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (50, '7');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (51, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (52, '-5');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (53, '0');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (54, '0');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (55, '0');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (56, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (57, 'profile.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (58, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (59, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (60, '');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (61, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (62, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (63, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (64, 'forward.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (65, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (66, 'htmlentities');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (67, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (68, '');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (69, 'n');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (70, 'yes');
    ALTER TABLE `%TABLES_PREFIX%users` ADD INDEX (`group_id`);
    ALTER TABLE `%TABLES_PREFIX%users` ADD INDEX (`signup_date`);
    ALTER TABLE `%TABLES_PREFIX%users` ADD INDEX (`email_address`);
    ALTER TABLE `%TABLES_PREFIX%templates` ADD INDEX (`template_type`);
    ALTER TABLE `%TABLES_PREFIX%cdata` ADD INDEX (`user_id`);
    ALTER TABLE `%TABLES_PREFIX%cdata` ADD INDEX (`cfield_id`);
    ALTER TABLE `%TABLES_PREFIX%cfields` ADD INDEX (`field_sname`);
    ALTER TABLE `%TABLES_PREFIX%cfields` ADD INDEX (`field_lname`);
    ALTER TABLE `%TABLES_PREFIX%cfields` ADD INDEX (`field_type`);
    ALTER TABLE `%TABLES_PREFIX%cfields` ADD INDEX (`field_req`);
    ALTER TABLE `%TABLES_PREFIX%cfields` ADD INDEX (`field_order`);
    ENDDB;

$LMDATABASE['upgrade']['1.0.0']['cleanup'] = <<<ENDDB
    DROP TABLE IF EXISTS `%TABLES_PREFIX%email_messages`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%email_queues`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%email_sending`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%email_templates`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%preferences_tmp`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%user_groups`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%user_list`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%user_queue`;
    ENDDB;

$LMDATABASE['upgrade']['0.9.5']['new'] = <<<ENDDB
    CREATE TABLE `%TABLES_PREFIX%cdata` (`cdata_id` int(12) NOT NULL auto_increment, `user_id` int(12) NOT NULL default '0', `cfield_id` int(12) NOT NULL default '0', `value` longtext NOT NULL, PRIMARY KEY (`cdata_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%cfields` (`cfields_id` int(12) NOT NULL auto_increment, `field_type` varchar(16) NOT NULL default '', `field_options` longtext, `field_sname` varchar(16) default NULL, `field_lname` varchar(64) default NULL, `field_length` int(12) default '0', `field_req` int(1) NOT NULL default '0', `field_order` int(3) NOT NULL default '0', PRIMARY KEY (`cfields_id`), UNIQUE KEY `field_sname` (`field_sname`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%confirmation` (`confirm_id` int(12) NOT NULL auto_increment, `date` bigint(64) NOT NULL default '0', `action` varchar(16) NOT NULL default '', `remote_ip` varchar(32) NOT NULL default '', `referrer` text NOT NULL, `user_agent` text NOT NULL, `email_address` varchar(128) NOT NULL default '', `firstname` varchar(32) NOT NULL default '', `lastname` varchar(64) NOT NULL default '', `group_ids` text NOT NULL, `cdata` text NOT NULL, `hash` varchar(64) NOT NULL default '', `confirmed` int(1) NOT NULL default '0', PRIMARY KEY (`confirm_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%groups` (`groups_id` int(12) NOT NULL auto_increment, `group_name` varchar(64) NOT NULL default '', `group_parent` int(12) NOT NULL default '0', `group_private` enum('true','false') NOT NULL default 'false', PRIMARY KEY (`groups_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%messages` (`message_id` int(12) NOT NULL auto_increment, `message_date` bigint(64) NOT NULL default '0', `message_title` varchar(255) NOT NULL default '', `message_subject` varchar(255) NOT NULL default '(no subject)', `message_from` text NOT NULL, `message_reply` text NOT NULL, `message_priority` int(1) NOT NULL default '0', `text_message` longtext NOT NULL, `text_template` int(12) default NULL, `html_message` longtext NOT NULL, `html_template` int(12) default NULL, `attachments` text NOT NULL, PRIMARY KEY (`message_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%preferences` (`preference_id` int(12) NOT NULL auto_increment, `preference_value` text NOT NULL, PRIMARY KEY (`preference_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=53;
    CREATE TABLE `%TABLES_PREFIX%queue` (`queue_id` int(12) NOT NULL auto_increment, `message_id` int(12) NOT NULL default '0', `date` bigint(64) NOT NULL default '0', `touch` bigint(64) NOT NULL default '0', `target` text NOT NULL, `progress` int(12) NOT NULL default '0', `total` int(12) NOT NULL default '0', `status` varchar(25) NOT NULL default '', PRIMARY KEY (`queue_id`), KEY `date` (`date`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%sending` (`sending_id` int(12) NOT NULL auto_increment, `email_address` varchar(128) NOT NULL default '', `users_id` int(12) NOT NULL default '0', `queue_id` int(12) NOT NULL default '0', `sent` tinyint(1) NOT NULL default '0', PRIMARY KEY  (`sending_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%sessions` (`sesskey` VARCHAR( 64 ) NOT NULL DEFAULT '', `expiry` TIMESTAMP NOT NULL, `expireref` VARCHAR( 250 ) DEFAULT '', `created` TIMESTAMP NOT NULL, `modified` TIMESTAMP NOT NULL, `sessdata` LONGTEXT, PRIMARY KEY (`sesskey`), INDEX sess2_expiry(`expiry`), INDEX sess2_expireref(`expireref`)) ENGINE=%TABLES_ENGINE%;
    CREATE TABLE `%TABLES_PREFIX%templates` (`template_id` int(12) NOT NULL auto_increment, `template_name` varchar(64) NOT NULL default '', `template_type` varchar(4) NOT NULL default 'html', `template_description` text, `template_content` longtext NOT NULL, PRIMARY KEY (`template_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%users` (`users_id` int(12) NOT NULL auto_increment, `group_id` int(12) NOT NULL default '0', `signup_date` bigint(64) NOT NULL default '0', `firstname` varchar(32) default NULL, `lastname` varchar(64) default NULL, `email_address` varchar(128) NOT NULL default '', PRIMARY KEY (`users_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%user_updates` (`updates_id` int(12) NOT NULL auto_increment, `hash` varchar(32) NOT NULL default '', `date` bigint(64) NOT NULL default '0', `email_address` varchar(128) NOT NULL default '0', `completed` int(1) NOT NULL default '0', PRIMARY KEY (`updates_id`), UNIQUE KEY `hash` (`hash`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (1, '%preferences[1]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (2, '%preferences[2]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (3, '%preferences[3]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (4, '%preferences[4]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (5, '2.2.1');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (6, '%preferences[6]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (7, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (8, '%preferences[8]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (9, '%preferences[9]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (10, 'archive.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (11, 'confirm.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (12, 'help.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (13, 'unsubscribe.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (14, '%preferences[14]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (15, '%preferences[15]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (16, '%preferences[14]%public/');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (17, '%preferences[17]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (18, '%preferences[18]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (19, '%preferences[4]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (20, '%preferences[20]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (21, '%preferences[21]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (22, '%preferences[22]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (23, '%preferences[23]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (24, '%preferences[24]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (25, '%preferences[25]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (26, '%preferences[26]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (27, '%preferences[27]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (28, '%preferences[28]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (29, '%preferences[29]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (30, 'tiny_mce');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (31, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (32, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (33, 'listmessenger.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (34, 'template.html');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (35, '%preferences[4]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (36, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (37, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (38, '');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (39, '');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (40, 'english');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (41, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (42, '60');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (43, '%preferences[4]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (44, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (45, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (46, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (47, '%preferences[15]%public/');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (48, '%preferences[14]%private/');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (49, 'ISO-8859-1');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (50, '7');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (51, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (52, '-5');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (53, '0');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (54, '0');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (55, '0');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (56, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (57, 'profile.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (58, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (59, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (60, '');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (61, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (62, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (63, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (64, 'forward.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (65, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (66, 'htmlentities');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (67, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (68, '');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (69, 'n');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (70, 'yes');
    ALTER TABLE `%TABLES_PREFIX%users` ADD INDEX (`group_id`);
    ALTER TABLE `%TABLES_PREFIX%users` ADD INDEX (`signup_date`);
    ALTER TABLE `%TABLES_PREFIX%users` ADD INDEX (`email_address`);
    ALTER TABLE `%TABLES_PREFIX%templates` ADD INDEX (`template_type`);
    ALTER TABLE `%TABLES_PREFIX%cdata` ADD INDEX (`user_id`);
    ALTER TABLE `%TABLES_PREFIX%cdata` ADD INDEX (`cfield_id`);
    ALTER TABLE `%TABLES_PREFIX%cfields` ADD INDEX (`field_sname`);
    ALTER TABLE `%TABLES_PREFIX%cfields` ADD INDEX (`field_lname`);
    ALTER TABLE `%TABLES_PREFIX%cfields` ADD INDEX (`field_type`);
    ALTER TABLE `%TABLES_PREFIX%cfields` ADD INDEX (`field_req`);
    ALTER TABLE `%TABLES_PREFIX%cfields` ADD INDEX (`field_order`);
    ENDDB;

$LMDATABASE['upgrade']['0.9.5']['cleanup'] = <<<ENDDB
    DROP TABLE IF EXISTS `%TABLES_PREFIX%email_messages`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%email_queues`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%email_sending`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%email_templates`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%preferences_tmp`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%user_groups`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%user_list`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%user_queue`;
    ENDDB;

$LMDATABASE['upgrade']['0.9.4']['new'] = <<<ENDDB
    CREATE TABLE `%TABLES_PREFIX%cdata` (`cdata_id` int(12) NOT NULL auto_increment, `user_id` int(12) NOT NULL default '0', `cfield_id` int(12) NOT NULL default '0', `value` longtext NOT NULL, PRIMARY KEY (`cdata_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%cfields` (`cfields_id` int(12) NOT NULL auto_increment, `field_type` varchar(16) NOT NULL default '', `field_options` longtext, `field_sname` varchar(16) default NULL, `field_lname` varchar(64) default NULL, `field_length` int(12) default '0', `field_req` int(1) NOT NULL default '0', `field_order` int(3) NOT NULL default '0', PRIMARY KEY (`cfields_id`), UNIQUE KEY `field_sname` (`field_sname`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%confirmation` (`confirm_id` int(12) NOT NULL auto_increment, `date` bigint(64) NOT NULL default '0', `action` varchar(16) NOT NULL default '', `remote_ip` varchar(32) NOT NULL default '', `referrer` text NOT NULL, `user_agent` text NOT NULL, `email_address` varchar(128) NOT NULL default '', `firstname` varchar(32) NOT NULL default '', `lastname` varchar(64) NOT NULL default '', `group_ids` text NOT NULL, `cdata` text NOT NULL, `hash` varchar(64) NOT NULL default '', `confirmed` int(1) NOT NULL default '0', PRIMARY KEY (`confirm_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%groups` (`groups_id` int(12) NOT NULL auto_increment, `group_name` varchar(64) NOT NULL default '', `group_parent` int(12) NOT NULL default '0', `group_private` enum('true','false') NOT NULL default 'false', PRIMARY KEY (`groups_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%messages` (`message_id` int(12) NOT NULL auto_increment, `message_date` bigint(64) NOT NULL default '0', `message_title` varchar(255) NOT NULL default '', `message_subject` varchar(255) NOT NULL default '(no subject)', `message_from` text NOT NULL, `message_reply` text NOT NULL, `message_priority` int(1) NOT NULL default '0', `text_message` longtext NOT NULL, `text_template` int(12) default NULL, `html_message` longtext NOT NULL, `html_template` int(12) default NULL, `attachments` text NOT NULL, PRIMARY KEY (`message_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%preferences` (`preference_id` int(12) NOT NULL auto_increment, `preference_value` text NOT NULL, PRIMARY KEY (`preference_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=53;
    CREATE TABLE `%TABLES_PREFIX%queue` (`queue_id` int(12) NOT NULL auto_increment, `message_id` int(12) NOT NULL default '0', `date` bigint(64) NOT NULL default '0', `touch` bigint(64) NOT NULL default '0', `target` text NOT NULL, `progress` int(12) NOT NULL default '0', `total` int(12) NOT NULL default '0', `status` varchar(25) NOT NULL default '', PRIMARY KEY (`queue_id`), KEY `date` (`date`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%sending` (`sending_id` int(12) NOT NULL auto_increment, `email_address` varchar(128) NOT NULL default '', `users_id` int(12) NOT NULL default '0', `queue_id` int(12) NOT NULL default '0', `sent` tinyint(1) NOT NULL default '0', PRIMARY KEY  (`sending_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%sessions` (`sesskey` VARCHAR( 64 ) NOT NULL DEFAULT '', `expiry` TIMESTAMP NOT NULL, `expireref` VARCHAR( 250 ) DEFAULT '', `created` TIMESTAMP NOT NULL, `modified` TIMESTAMP NOT NULL, `sessdata` LONGTEXT, PRIMARY KEY (`sesskey`), INDEX sess2_expiry(`expiry`), INDEX sess2_expireref(`expireref`)) ENGINE=%TABLES_ENGINE%;
    CREATE TABLE `%TABLES_PREFIX%templates` (`template_id` int(12) NOT NULL auto_increment, `template_name` varchar(64) NOT NULL default '', `template_type` varchar(4) NOT NULL default 'html', `template_description` text, `template_content` longtext NOT NULL, PRIMARY KEY (`template_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%users` (`users_id` int(12) NOT NULL auto_increment, `group_id` int(12) NOT NULL default '0', `signup_date` bigint(64) NOT NULL default '0', `firstname` varchar(32) default NULL, `lastname` varchar(64) default NULL, `email_address` varchar(128) NOT NULL default '', PRIMARY KEY (`users_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%user_updates` (`updates_id` int(12) NOT NULL auto_increment, `hash` varchar(32) NOT NULL default '', `date` bigint(64) NOT NULL default '0', `email_address` varchar(128) NOT NULL default '0', `completed` int(1) NOT NULL default '0', PRIMARY KEY (`updates_id`), UNIQUE KEY `hash` (`hash`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (1, '%preferences[1]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (2, '%preferences[2]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (3, '%preferences[3]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (4, '%preferences[4]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (5, '2.2.1');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (6, '%preferences[6]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (7, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (8, '%preferences[8]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (9, '%preferences[9]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (10, 'archive.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (11, 'confirm.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (12, 'help.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (13, 'unsubscribe.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (14, '%preferences[14]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (15, '%preferences[15]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (16, '%preferences[14]%public/');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (17, '%preferences[17]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (18, '%preferences[18]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (19, '%preferences[4]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (20, '%preferences[20]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (21, '%preferences[21]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (22, '%preferences[22]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (23, '%preferences[23]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (24, '%preferences[24]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (25, '%preferences[25]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (26, '%preferences[26]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (27, '%preferences[27]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (28, '%preferences[28]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (29, '%preferences[29]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (30, 'tiny_mce');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (31, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (32, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (33, 'listmessenger.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (34, 'template.html');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (35, '%preferences[4]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (36, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (37, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (38, '');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (39, '');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (40, 'english');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (41, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (42, '60');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (43, '%preferences[4]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (44, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (45, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (46, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (47, '%preferences[15]%public/');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (48, '%preferences[14]%private/');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (49, 'ISO-8859-1');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (50, '7');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (51, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (52, '-5');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (53, '0');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (54, '0');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (55, '0');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (56, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (57, 'profile.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (58, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (59, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (60, '');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (61, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (62, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (63, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (64, 'forward.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (65, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (66, 'htmlentities');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (67, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (68, '');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (69, 'n');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (70, 'yes');
    ALTER TABLE `%TABLES_PREFIX%users` ADD INDEX (`group_id`);
    ALTER TABLE `%TABLES_PREFIX%users` ADD INDEX (`signup_date`);
    ALTER TABLE `%TABLES_PREFIX%users` ADD INDEX (`email_address`);
    ALTER TABLE `%TABLES_PREFIX%templates` ADD INDEX (`template_type`);
    ALTER TABLE `%TABLES_PREFIX%cdata` ADD INDEX (`user_id`);
    ALTER TABLE `%TABLES_PREFIX%cdata` ADD INDEX (`cfield_id`);
    ALTER TABLE `%TABLES_PREFIX%cfields` ADD INDEX (`field_sname`);
    ALTER TABLE `%TABLES_PREFIX%cfields` ADD INDEX (`field_lname`);
    ALTER TABLE `%TABLES_PREFIX%cfields` ADD INDEX (`field_type`);
    ALTER TABLE `%TABLES_PREFIX%cfields` ADD INDEX (`field_req`);
    ALTER TABLE `%TABLES_PREFIX%cfields` ADD INDEX (`field_order`);
    ENDDB;

$LMDATABASE['upgrade']['0.9.4']['cleanup'] = <<<ENDDB
    DROP TABLE IF EXISTS `%TABLES_PREFIX%email_messages`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%email_queues`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%email_sending`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%email_templates`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%preferences_tmp`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%user_groups`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%user_list`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%user_queue`;
    ENDDB;

$LMDATABASE['upgrade']['0.9.3']['new'] = <<<ENDDB
    CREATE TABLE `%TABLES_PREFIX%cdata` (`cdata_id` int(12) NOT NULL auto_increment, `user_id` int(12) NOT NULL default '0', `cfield_id` int(12) NOT NULL default '0', `value` longtext NOT NULL, PRIMARY KEY (`cdata_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%cfields` (`cfields_id` int(12) NOT NULL auto_increment, `field_type` varchar(16) NOT NULL default '', `field_options` longtext, `field_sname` varchar(16) default NULL, `field_lname` varchar(64) default NULL, `field_length` int(12) default '0', `field_req` int(1) NOT NULL default '0', `field_order` int(3) NOT NULL default '0', PRIMARY KEY (`cfields_id`), UNIQUE KEY `field_sname` (`field_sname`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%confirmation` (`confirm_id` int(12) NOT NULL auto_increment, `date` bigint(64) NOT NULL default '0', `action` varchar(16) NOT NULL default '', `remote_ip` varchar(32) NOT NULL default '', `referrer` text NOT NULL, `user_agent` text NOT NULL, `email_address` varchar(128) NOT NULL default '', `firstname` varchar(32) NOT NULL default '', `lastname` varchar(64) NOT NULL default '', `group_ids` text NOT NULL, `cdata` text NOT NULL, `hash` varchar(64) NOT NULL default '', `confirmed` int(1) NOT NULL default '0', PRIMARY KEY (`confirm_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%groups` (`groups_id` int(12) NOT NULL auto_increment, `group_name` varchar(64) NOT NULL default '', `group_parent` int(12) NOT NULL default '0', `group_private` enum('true','false') NOT NULL default 'false', PRIMARY KEY (`groups_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%messages` (`message_id` int(12) NOT NULL auto_increment, `message_date` bigint(64) NOT NULL default '0', `message_title` varchar(255) NOT NULL default '', `message_subject` varchar(255) NOT NULL default '(no subject)', `message_from` text NOT NULL, `message_reply` text NOT NULL, `message_priority` int(1) NOT NULL default '0', `text_message` longtext NOT NULL, `text_template` int(12) default NULL, `html_message` longtext NOT NULL, `html_template` int(12) default NULL, `attachments` text NOT NULL, PRIMARY KEY (`message_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%preferences` (`preference_id` int(12) NOT NULL auto_increment, `preference_value` text NOT NULL, PRIMARY KEY (`preference_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=53;
    CREATE TABLE `%TABLES_PREFIX%queue` (`queue_id` int(12) NOT NULL auto_increment, `message_id` int(12) NOT NULL default '0', `date` bigint(64) NOT NULL default '0', `touch` bigint(64) NOT NULL default '0', `target` text NOT NULL, `progress` int(12) NOT NULL default '0', `total` int(12) NOT NULL default '0', `status` varchar(25) NOT NULL default '', PRIMARY KEY (`queue_id`), KEY `date` (`date`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%sending` (`sending_id` int(12) NOT NULL auto_increment, `email_address` varchar(128) NOT NULL default '', `users_id` int(12) NOT NULL default '0', `queue_id` int(12) NOT NULL default '0', `sent` tinyint(1) NOT NULL default '0', PRIMARY KEY  (`sending_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%sessions` (`sesskey` VARCHAR( 64 ) NOT NULL DEFAULT '', `expiry` TIMESTAMP NOT NULL, `expireref` VARCHAR( 250 ) DEFAULT '', `created` TIMESTAMP NOT NULL, `modified` TIMESTAMP NOT NULL, `sessdata` LONGTEXT, PRIMARY KEY (`sesskey`), INDEX sess2_expiry(`expiry`), INDEX sess2_expireref(`expireref`)) ENGINE=%TABLES_ENGINE%;
    CREATE TABLE `%TABLES_PREFIX%templates` (`template_id` int(12) NOT NULL auto_increment, `template_name` varchar(64) NOT NULL default '', `template_type` varchar(4) NOT NULL default 'html', `template_description` text, `template_content` longtext NOT NULL, PRIMARY KEY (`template_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%users` (`users_id` int(12) NOT NULL auto_increment, `group_id` int(12) NOT NULL default '0', `signup_date` bigint(64) NOT NULL default '0', `firstname` varchar(32) default NULL, `lastname` varchar(64) default NULL, `email_address` varchar(128) NOT NULL default '', PRIMARY KEY (`users_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%user_updates` (`updates_id` int(12) NOT NULL auto_increment, `hash` varchar(32) NOT NULL default '', `date` bigint(64) NOT NULL default '0', `email_address` varchar(128) NOT NULL default '0', `completed` int(1) NOT NULL default '0', PRIMARY KEY (`updates_id`), UNIQUE KEY `hash` (`hash`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (1, '%preferences[1]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (2, '%preferences[2]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (3, '%preferences[3]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (4, '%preferences[4]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (5, '2.2.1');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (6, '%preferences[6]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (7, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (8, '%preferences[8]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (9, '%preferences[9]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (10, 'archive.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (11, 'confirm.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (12, 'help.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (13, 'unsubscribe.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (14, '%preferences[14]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (15, '%preferences[15]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (16, '%preferences[14]%public/');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (17, '%preferences[17]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (18, '%preferences[18]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (19, '%preferences[4]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (20, '%preferences[20]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (21, '%preferences[21]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (22, '%preferences[22]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (23, '%preferences[23]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (24, '%preferences[24]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (25, '%preferences[25]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (26, '%preferences[26]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (27, '%preferences[27]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (28, '%preferences[28]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (29, '%preferences[29]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (30, 'tiny_mce');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (31, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (32, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (33, 'listmessenger.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (34, 'template.html');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (35, '%preferences[4]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (36, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (37, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (38, '');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (39, '');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (40, 'english');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (41, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (42, '60');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (43, '%preferences[4]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (44, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (45, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (46, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (47, '%preferences[15]%public/');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (48, '%preferences[14]%private/');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (49, 'ISO-8859-1');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (50, '7');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (51, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (52, '-5');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (53, '0');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (54, '0');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (55, '0');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (56, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (57, 'profile.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (58, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (59, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (60, '');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (61, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (62, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (63, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (64, 'forward.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (65, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (66, 'htmlentities');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (67, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (68, '');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (69, 'n');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (70, 'yes');
    ALTER TABLE `%TABLES_PREFIX%users` ADD INDEX (`group_id`);
    ALTER TABLE `%TABLES_PREFIX%users` ADD INDEX (`signup_date`);
    ALTER TABLE `%TABLES_PREFIX%users` ADD INDEX (`email_address`);
    ALTER TABLE `%TABLES_PREFIX%templates` ADD INDEX (`template_type`);
    ALTER TABLE `%TABLES_PREFIX%cdata` ADD INDEX (`user_id`);
    ALTER TABLE `%TABLES_PREFIX%cdata` ADD INDEX (`cfield_id`);
    ALTER TABLE `%TABLES_PREFIX%cfields` ADD INDEX (`field_sname`);
    ALTER TABLE `%TABLES_PREFIX%cfields` ADD INDEX (`field_lname`);
    ALTER TABLE `%TABLES_PREFIX%cfields` ADD INDEX (`field_type`);
    ALTER TABLE `%TABLES_PREFIX%cfields` ADD INDEX (`field_req`);
    ALTER TABLE `%TABLES_PREFIX%cfields` ADD INDEX (`field_order`);
    ENDDB;

$LMDATABASE['upgrade']['0.9.3']['cleanup'] = <<<ENDDB
    DROP TABLE IF EXISTS `%TABLES_PREFIX%email_messages`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%email_queues`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%email_sending`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%email_templates`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%preferences_tmp`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%user_groups`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%user_list`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%user_queue`;
    ENDDB;

$LMDATABASE['upgrade']['0.5.0']['new'] = <<<ENDDB
    CREATE TABLE `%TABLES_PREFIX%cdata` (`cdata_id` int(12) NOT NULL auto_increment, `user_id` int(12) NOT NULL default '0', `cfield_id` int(12) NOT NULL default '0', `value` longtext NOT NULL, PRIMARY KEY (`cdata_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%cfields` (`cfields_id` int(12) NOT NULL auto_increment, `field_type` varchar(16) NOT NULL default '', `field_options` longtext, `field_sname` varchar(16) default NULL, `field_lname` varchar(64) default NULL, `field_length` int(12) default '0', `field_req` int(1) NOT NULL default '0', `field_order` int(3) NOT NULL default '0', PRIMARY KEY (`cfields_id`), UNIQUE KEY `field_sname` (`field_sname`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%confirmation` (`confirm_id` int(12) NOT NULL auto_increment, `date` bigint(64) NOT NULL default '0', `action` varchar(16) NOT NULL default '', `remote_ip` varchar(32) NOT NULL default '', `referrer` text NOT NULL, `user_agent` text NOT NULL, `email_address` varchar(128) NOT NULL default '', `firstname` varchar(32) NOT NULL default '', `lastname` varchar(64) NOT NULL default '', `group_ids` text NOT NULL, `cdata` text NOT NULL, `hash` varchar(64) NOT NULL default '', `confirmed` int(1) NOT NULL default '0', PRIMARY KEY (`confirm_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%groups` (`groups_id` int(12) NOT NULL auto_increment, `group_name` varchar(64) NOT NULL default '', `group_parent` int(12) NOT NULL default '0', `group_private` enum('true','false') NOT NULL default 'false', PRIMARY KEY (`groups_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%messages` (`message_id` int(12) NOT NULL auto_increment, `message_date` bigint(64) NOT NULL default '0', `message_title` varchar(255) NOT NULL default '', `message_subject` varchar(255) NOT NULL default '(no subject)', `message_from` text NOT NULL, `message_reply` text NOT NULL, `message_priority` int(1) NOT NULL default '0', `text_message` longtext NOT NULL, `text_template` int(12) default NULL, `html_message` longtext NOT NULL, `html_template` int(12) default NULL, `attachments` text NOT NULL, PRIMARY KEY (`message_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%preferences` (`preference_id` int(12) NOT NULL auto_increment, `preference_value` text NOT NULL, PRIMARY KEY (`preference_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=53;
    CREATE TABLE `%TABLES_PREFIX%queue` (`queue_id` int(12) NOT NULL auto_increment, `message_id` int(12) NOT NULL default '0', `date` bigint(64) NOT NULL default '0', `touch` bigint(64) NOT NULL default '0', `target` text NOT NULL, `progress` int(12) NOT NULL default '0', `total` int(12) NOT NULL default '0', `status` varchar(25) NOT NULL default '', PRIMARY KEY (`queue_id`), KEY `date` (`date`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%sending` (`sending_id` int(12) NOT NULL auto_increment, `email_address` varchar(128) NOT NULL default '', `users_id` int(12) NOT NULL default '0', `queue_id` int(12) NOT NULL default '0', `sent` tinyint(1) NOT NULL default '0', PRIMARY KEY  (`sending_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%sessions` (`sesskey` VARCHAR( 64 ) NOT NULL DEFAULT '', `expiry` TIMESTAMP NOT NULL, `expireref` VARCHAR( 250 ) DEFAULT '', `created` TIMESTAMP NOT NULL, `modified` TIMESTAMP NOT NULL, `sessdata` LONGTEXT, PRIMARY KEY (`sesskey`), INDEX sess2_expiry(`expiry`), INDEX sess2_expireref(`expireref`)) ENGINE=%TABLES_ENGINE%;
    CREATE TABLE `%TABLES_PREFIX%templates` (`template_id` int(12) NOT NULL auto_increment, `template_name` varchar(64) NOT NULL default '', `template_type` varchar(4) NOT NULL default 'html', `template_description` text, `template_content` longtext NOT NULL, PRIMARY KEY (`template_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%users` (`users_id` int(12) NOT NULL auto_increment, `group_id` int(12) NOT NULL default '0', `signup_date` bigint(64) NOT NULL default '0', `firstname` varchar(32) default NULL, `lastname` varchar(64) default NULL, `email_address` varchar(128) NOT NULL default '', PRIMARY KEY (`users_id`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    CREATE TABLE `%TABLES_PREFIX%user_updates` (`updates_id` int(12) NOT NULL auto_increment, `hash` varchar(32) NOT NULL default '', `date` bigint(64) NOT NULL default '0', `email_address` varchar(128) NOT NULL default '0', `completed` int(1) NOT NULL default '0', PRIMARY KEY (`updates_id`), UNIQUE KEY `hash` (`hash`)) ENGINE=%TABLES_ENGINE% AUTO_INCREMENT=1;
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (1, '%preferences[1]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (2, '%preferences[2]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (3, '%preferences[3]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (4, '%preferences[4]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (5, '2.2.1');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (6, '%preferences[6]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (7, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (8, '%preferences[8]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (9, '25');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (10, 'archive.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (11, 'confirm.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (12, 'help.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (13, 'unsubscribe.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (14, '%preferences[14]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (15, '%preferences[15]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (16, '%preferences[14]%public/');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (17, '76');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (18, '75');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (19, '%preferences[4]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (20, '%preferences[20]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (21, '%preferences[21]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (22, '%preferences[22]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (23, 'M jS Y g:ia');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (24, '1');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (25, 'mail');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (26, '');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (27, 'false');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (28, '');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (29, '');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (30, 'tiny_mce');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (31, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (32, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (33, 'listmessenger.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (34, 'template.html');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (35, '%preferences[4]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (36, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (37, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (38, '');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (39, '');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (40, 'english');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (41, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (42, '60');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (43, '%preferences[4]%');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (44, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (45, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (46, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (47, '%preferences[15]%public/');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (48, '%preferences[14]%private/');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (49, 'ISO-8859-1');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (50, '7');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (51, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (52, '-5');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (53, '0');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (54, '0');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (55, '0');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (56, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (57, 'profile.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (58, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (59, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (60, '');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (61, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (62, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (63, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (64, 'forward.php');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (65, 'no');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (66, 'htmlentities');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (67, 'yes');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (68, '');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (69, 'n');
    INSERT INTO `%TABLES_PREFIX%preferences` VALUES (70, 'yes');
    ALTER TABLE `%TABLES_PREFIX%users` ADD INDEX (`group_id`);
    ALTER TABLE `%TABLES_PREFIX%users` ADD INDEX (`signup_date`);
    ALTER TABLE `%TABLES_PREFIX%users` ADD INDEX (`email_address`);
    ALTER TABLE `%TABLES_PREFIX%templates` ADD INDEX (`template_type`);
    ALTER TABLE `%TABLES_PREFIX%cdata` ADD INDEX (`user_id`);
    ALTER TABLE `%TABLES_PREFIX%cdata` ADD INDEX (`cfield_id`);
    ALTER TABLE `%TABLES_PREFIX%cfields` ADD INDEX (`field_sname`);
    ALTER TABLE `%TABLES_PREFIX%cfields` ADD INDEX (`field_lname`);
    ALTER TABLE `%TABLES_PREFIX%cfields` ADD INDEX (`field_type`);
    ALTER TABLE `%TABLES_PREFIX%cfields` ADD INDEX (`field_req`);
    ALTER TABLE `%TABLES_PREFIX%cfields` ADD INDEX (`field_order`);
    ENDDB;

$LMDATABASE['upgrade']['0.5.0']['cleanup'] = <<<ENDDB
    DROP TABLE IF EXISTS `%TABLES_PREFIX%preferences_tmp`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%sent_messages`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%sent_templates`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%user_groups`;
    DROP TABLE IF EXISTS `%TABLES_PREFIX%user_list`;
    ENDDB;
